<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class UltimateAI_OpenAI_Args_Settings
{
  //MODELS
  private $models = array(
    "one"  => "gpt-4o",
    "two"  => "gpt-4-32k",
    "three"  => "whisper-1",
    "vision"  => "gpt-4-1106-vision-preview"
  );

  private $default_args_chat_api_args = array(
    "temperature" => 0.2,
    "max_tokens" => null,
    "top_p"  => 1,
    "frequency_penalty"  => 0,
  );

  public function args_generator_for_chat_api($prompt,  $model, $max_token, $is_stream = false)
  {
    $theme_settings_manager = new Ultimate_AI_Theme_Setting_Manager();
    $app_settings = $theme_settings_manager->ultimate_ai_get_theme_settings(['uai_app_settings']);
    $args = $this->default_args_chat_api_args;
    if (!empty($app_settings["uai_app_settings"]["default_gpt_model"])) {
      $args["model"] = $app_settings["uai_app_settings"]["default_gpt_model"];
    }

    if (!empty($this->models[$model])) $args["model"] = $this->models[empty($model) ? "one" : $model];

    //if (!empty($max_token)) $args["max_tokens"] = (int) $max_token; //summary get strip if max_tokens is small
    if ($is_stream) $args["stream"] = true;
    $args["messages"] = $prompt;

    return json_encode($args);
  }

  private $image_sizes = array("small" => "256x256", "medium" => "512x512", "large" => "1024x1024", "extra_large" => "1792x1024");
  private $default_img_generation_args = array(
    "n"  => 1, //The number of images to generate. Must be between 1 and 10.
    "size"  => "512x512",
    "response_format" => "b64_json",
  );
  public function args_generator_for_image_generation_api($prompt = "", $image_size = "medium", $num_of_img = 1, $over_write_args = array(), $is_variation = false)
  {
    $args = $this->default_img_generation_args;

    if ($is_variation) $args["image"] = $prompt; //if is_variation  api then prompt is temp image file path
    if (!$is_variation) $args["prompt"] = $prompt;

    $args["size"] = $this->image_sizes[$image_size];
    $args["n"] = $num_of_img;

    return $is_variation ? array_merge($args, $over_write_args) : json_encode(array_merge($args, $over_write_args));
  }

  private $default_audio_to_text_args = array(
    "prompt" => "",
    "response_format" => "json", // available format "json/text/srt/verbose_json/vtt"
    "temperature" => 0,
    "language" => "",
  );
  public function args_generator_for_speech_to_text_api($new_args = array())
  {
    //$new_args must have a file field
    $args = $this->default_audio_to_text_args;
    $args["model"] = $this->models["two"];
    return json_encode(array_merge($this->default_audio_to_text_args, $new_args));
  }
}
